class Heap:
    def __init__(self) -> None:
        self.arr = [None]
        self.size = 0

    def insert(self, value: int):
        self.size += 1
        self.arr.append(value)
        self.bubble_up(self.size)

    def extract_min(self) -> int:
        self.swap(1, self.size)
        self.size -= 1
        self.bubble_down(1)
        return self.arr.pop(-1)

    def bubble_up(self, pos: int):
        parent = pos // 2

        if parent is 0: return

        if self.arr[pos] < self.arr[parent]:
            self.swap(pos, parent)
            self.bubble_up(parent)

    def bubble_down(self, pos: int):
        left = pos * 2
        right = pos * 2 + 1

        if left > self.size: return
        smaller = right if right <= self.size and self.arr[left] > self.arr[right] else left

        if self.arr[pos] > self.arr[smaller]:
            self.swap(pos, smaller)
            self.bubble_down(smaller)

    def swap(self, u: int, v: int):
        tmp = self.arr[u]
        self.arr[u] = self.arr[v]
        self.arr[v] = tmp
