

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class Probl8 {
    public static void main(String[] args) throws IOException {
//        System.setOut(new PrintStream(Files.newOutputStream(Paths.get("probl8sol.txt"))));
        BufferedReader in = Files.newBufferedReader(Paths.get("graph.txt"));
        
        String line = in.readLine();
        int space = line.indexOf(' ');
        final int n = Integer.parseInt(line.substring(0, space));
        final int m = Integer.parseInt(line.substring(space + 1));
        
        final IntList[] adj = new IntList[n];
        for(int i = 0; i < adj.length; i++)
            adj[i] = new IntList();
        
        for(int i = 0; i < m; i++) {
            line = in.readLine();
            StringTokenizer st = new StringTokenizer(line);
            final int u = Integer.parseInt(st.nextToken());
            final int v = Integer.parseInt(st.nextToken());
            adj[u].add(v);
            adj[v].add(u);
        }
        
        System.out.println("Distance 0-7 is : " + bfs(adj, 0)[7]);
    }
    
    static int[] bfs(IntList[] adj, int s) {
        final boolean[] visited = new boolean[adj.length];
        final LinkedList<Integer> queue = new LinkedList<>();
        queue.addLast(s);
        visited[s] = true;
        final int[] dist = new int[adj.length];
        
        while(!queue.isEmpty()) {
            final int v = queue.removeFirst();
            for(int w : adj[v])
                if(! visited[w]) {
                    dist[w] = dist[v] + 1;
                    visited[w] = true;
                    queue.addLast(w);
                    
                    // we can stop when we reach 7, but ...
                }
        }
        
        return dist;
    }
}

