

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class Probl7 {
    public static void main(String[] args) throws IOException {
//        System.setOut(new PrintStream(Files.newOutputStream(Paths.get("probl7sol.txt"))));
        BufferedReader in = Files.newBufferedReader(Paths.get("graph.txt"));
        
        String line = in.readLine();
        int space = line.indexOf(' ');
        final int n = Integer.parseInt(line.substring(0, space));
        final int m = Integer.parseInt(line.substring(space + 1));
        
        final IntList[] adj = new IntList[n];
        for(int i = 0; i < adj.length; i++)
            adj[i] = new IntList();
        
        for(int i = 0; i < m; i++) {
            line = in.readLine();
            StringTokenizer st = new StringTokenizer(line);
            final int u = Integer.parseInt(st.nextToken());
            final int v = Integer.parseInt(st.nextToken());
            adj[u].add(v);
            adj[v].add(u);
        }
        
        bfs(adj, 0);
    }
    
    static void bfs(IntList[] adj, int s) {
        final boolean[] visited = new boolean[adj.length];
        final LinkedList<Integer> queue = new LinkedList<>();
        queue.addLast(s);
        visited[s] = true;
        int visitedVertices = 1;
        
        while(!queue.isEmpty()) {
            final int v = queue.removeFirst();
            System.out.println(v);
            for(int w : adj[v])
                if(! visited[w]) {
                    visited[w] = true;
                    queue.addLast(w);
                    visitedVertices++;
                }
        }
        
        System.out.println("Number of vertices that are reachable : "+visitedVertices);
    }
}

class IntList extends ArrayList<Integer> {
}
