
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public class DijkstraNaive {

    public static void main(String[] args) throws IOException {
        System.setOut(new PrintStream(Files.newOutputStream(Paths.get("dikstra.txt"))));
        BufferedReader in = Files.newBufferedReader(Paths.get("graphweighted.txt"));

        String line = in.readLine();
        int space = line.indexOf(' ');
        final int n = Integer.parseInt(line.substring(0, space));
        final int m = Integer.parseInt(line.substring(space + 1));

        final EdgeList[] adj = new EdgeList[n];
        for (int i = 0; i < adj.length; i++) {
            adj[i] = new EdgeList();
        }

        for (int i = 0; i < m; i++) {
            line = in.readLine();
            StringTokenizer st = new StringTokenizer(line);
            final int u = Integer.parseInt(st.nextToken());
            final int v = Integer.parseInt(st.nextToken());
            final int len = Integer.parseInt(st.nextToken());
            adj[u].add(new Edge(v, len));
            adj[v].add(new Edge(u, len));
        }
        
        final int[] result = dijkstra(adj, 0);
        for(int i : result)
            System.out.println(i);
    }

    public static int[] dijkstra(EdgeList[] adj, int s) {
        // for each vertex, remember whether in X
        final boolean[] isInX = new boolean[adj.length];
        // array of distances
        final int[] dist = new int[adj.length];

        // MAXVALUE is infinity
        Arrays.fill(dist, Integer.MAX_VALUE);
        dist[s] = 0;
        isInX[s] = true;

        while (true) {
            // look on all edges going from X outside
            // and pick the one with minimum Dijkstra's greedy score
            int minimumScore = Integer.MAX_VALUE;
            Edge edg_star = null;
            for (int v = 0; v < adj.length; v++) {
                if (isInX[v]) // v in X
                {
                    for (Edge edg : adj[v]) {
                        if (!isInX[edg.target]) // w not in x
                        {
                            // pick the minimum out of those edges
                            
                            //calculate the score
                            final int vwScore = dist[v] + edg.length;
                            
                            if(vwScore < minimumScore) {
                                minimumScore = vwScore;
                                edg_star = edg;
                            }
                        }
                    }
                }
            }
            // Minimum score should be known
            if(minimumScore == Integer.MAX_VALUE)
                return dist;
            
            // we have found v* to w*
            isInX[edg_star.target] = true;
            dist[edg_star.target] = minimumScore;
        }
    }
}

class Edge {

    final int target;
    final int length;

    public Edge(int target, int length) {
        this.target = target;
        this.length = length;
    }
}

class EdgeList extends ArrayList<Edge> {

}
