
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.StringTokenizer;

public class Probl9 {

    public static void main(String[] args) throws IOException {
//        System.setOut(new PrintStream(Files.newOutputStream(Paths.get("probl9sol.txt"))));
        BufferedReader in = Files.newBufferedReader(Paths.get("graph.txt"));

        String line = in.readLine();
        int space = line.indexOf(' ');
        final int n = Integer.parseInt(line.substring(0, space));
        final int m = Integer.parseInt(line.substring(space + 1));

        final IntList[] adj = new IntList[n];
        for (int i = 0; i < adj.length; i++) {
            adj[i] = new IntList();
        }

        for (int i = 0; i < m; i++) {
            line = in.readLine();
            StringTokenizer st = new StringTokenizer(line);
            final int u = Integer.parseInt(st.nextToken());
            final int v = Integer.parseInt(st.nextToken());
            adj[u].add(v);
            adj[v].add(u);
        }

        System.out.println("No. of components : " + connectedComponents(adj));
    }

    static int connectedComponents(IntList[] adj) {
        final boolean[] visited = new boolean[adj.length];
        int count = 0;
        for (int i = 0; i < visited.length; i++) {
            if(!visited[i]) {
                dfs(adj, i, visited);
                count++;
            }
        }
        return count;
    }

    static void dfs(IntList[] adj, int s, boolean[] visited) {
        visited[s] = true;

        for (int w : adj[s]) {
            if (!visited[w]) {
                dfs(adj, w, visited);
            }
        }
    }
}
