import numpy


def find_start(maze):
    starts = numpy.argwhere(maze == "S")
    assert len(starts) == 1

    return tuple(starts[0])


def oracle_path(maze, sensors, probs):
    """Finds the path with the lowest expected visibility."""

    start = find_start(maze)

    # Use an algorithm such as Dijkstra. The template was replaced
    # by the following pseudocode, based on the survey of 2024.
    # If you want the template back, tell us! :)

    # for v in nodes in maze:
    #     state[v] = unknown
    #     distance[v] = +inf
    #     predecessor[v] = unknown
    # state[start] = open
    # distance[start] = 0
    # while there exist any open nodes:
    #     v = an open node with the smallest distance[v]
    #     for w in neighbours of v:
    #         if distance[w] > distance[v] + dist(v, w):
    #             distance[w] = distance[v] + dist(v, w)
    #             state[w] = open
    #             predecessor[w] = v
    #     state[v] = closed

    return (float("nan"), [start])
