import gurobipy as gp

from gurobipy import GRB


_GRB_BRUTE_ENV = gp.Env(empty=True)
_GRB_BRUTE_ENV.setParam("Threads", 1)
_GRB_BRUTE_ENV.setParam("OutputFlag", 0)
_GRB_BRUTE_ENV.start()


def mixed_nash_linear_program(L, _gurobi_env=_GRB_BRUTE_ENV):
    """Returns the value of the game and the strategies of both players
    which minimize the loss of the row player."""

    nx, ny = L.shape

    model = gp.Model(env=_gurobi_env)

    v = model.addVar(lb=float("-inf"))
    yvar = model.addMVar(shape=ny, ub=1)

    xcon = model.addConstr(L @ yvar >= v)
    model.addConstr(yvar.sum() == 1)
    model.setObjective(v, sense=GRB.MAXIMIZE)

    model.optimize()

    if model.status == GRB.OPTIMAL:
        return model.ObjVal, -xcon.Pi, yvar.X
    else:
        return float("nan")
