import sys
import numpy

from algorithm import run_double_oracle


def read_input(io, argv):
    assert len(argv) == 2, "Usage: main.py eps < maze"

    eps = float(argv[1])
    lines = [list(lin) for lin in map(str.strip, io.readlines()) if lin]
    maze = numpy.array(lines)

    return maze, eps


if __name__ == "__main__":
    maze, eps = read_input(sys.stdin, sys.argv)
    visibility = run_double_oracle(maze, eps)
    print(visibility)
