#include <stdio.h>

int main(){
	int day, month, year;

	while(1){
	
		printf("Enter date in format YYYY-MM-DD\n");
		
		//read input
		int ret = scanf("%d-%d-%d", &year, &month, &day);
		
		// check if scanf managed to read three numbers separated by '-' from input
		if(ret != 3){
			printf("Wrong input format, exiting program\n");
			break;
		}
		
		// handle day suffix
		char* day_suffix;
		switch(day % 10){
			case 1: 
				day_suffix = "st";
				break;
			case 2:
				day_suffix = "nd";
				break;
			case 3:
				day_suffix = "rd";
				break;
			default:
				day_suffix = "th";
		}
		
		//handle month name
		char* month_name;
		switch (month) {
			case 1:  month_name = "January";   break;
			case 2:  month_name = "February";  break;
			case 3:  month_name = "March";     break;
			case 4:  month_name = "April";     break;
			case 5:  month_name = "May";       break;
			case 6:  month_name = "June";      break;
			case 7:  month_name = "July";      break;
			case 8:  month_name = "August";    break;
			case 9:  month_name = "September"; break;
			case 10: month_name = "October";   break;
			case 11: month_name = "November";  break;
			case 12: month_name = "December";  break;
			default: 
			    printf("Invalid month!\n");
			    return 1;
		 }
		 
		 //print result
		 printf("%d%s %s %d\n", day, day_suffix, month_name, year);
				
	}
	
	return 0;
}

