import numpy as np
import matplotlib.pyplot as plt
import matplotlib.animation as animation

x = np.linspace(0, 4 * np.pi, 500)
y = np.sin(x)

fig, ax = plt.subplots()
ax.plot(x, y)
dot, = ax.plot(0, 0, '.', c='r', ms=20)

def data_generator():
    for i in range(1, np.size(x)):
        yield x[i], y[i]

def update(data):
    x, y = data
    dot.set_data(x, y)

    return dot,

ani = animation.FuncAnimation(fig, update, data_generator, interval=1, blit=True)

plt.show()