# %% [markdown]
# # Základy programování
# 02.10.2023

# %% [markdown]
# ## Proměné a jejich hodnoty, výpis

# %%
a = 10
print("a =", a)
pocetLidiVeTride = 20
a = "ahoj"
print("a =", a)
a = 20
print("a =", a)
b = 10
print(a + b)
c = a + b
print(c)
a = a + 10
print("a =", a)

# %% [markdown]
# ## Operátory, přetypování

# %%
print(10%3)
print(10//3)
a = "ahoj"
b = "svete"
print(a + " " + str(10))
print(float("3.15"), 10, 20, sep="\n")

# %% [markdown]
# ## Logické výrazy a operátory

# %%
a = 10
b = 20
print(a==b)
print(a < b)

# %% [markdown]
# ## Větvení

# %%
a = 0

if a > 0:
    print(a, "je kladne")
else:
    if a < 0:
        print(a, "je zaporne")
    else:
        print(a, "je nula")



# %% [markdown]
# ## Cykly

# %%
import math

D = int(input())
H = 10

if D > H:
    T = H   # poznamemam si hodnotu H
    H = D   # zmenim H
    D = T   # zmenim D na poznamenanou hodnotu

for a in range(D, H):
    print(a, " ", math.sin(a))


# %% [markdown]
# ## Lichá čísla
# Kombinace **cyklu** a **podmínky**. Lichost je vyhodnocena pomocí operátoru **modulo**, jehož výsledkem je v tomto případě **0** nebo **1**. Pokud je zbytek po celočíselném dělení dvěma roven **1** (tj. je liché), je výraz vyhodnocen jako pravivý a vytiskne se informace.  

# %%
for a in range(10):
    if (a % 2):
        print(a, " je liché")

# %% [markdown]
# ## Sudá čísla
# Porovnej logický výraz s předchozím příkladem a promysli si, proč je to právě takto.

# %%
for a in range(10):
    if not (a % 2):
        print(a, "je sudé")

# %% [markdown]
# ## Formátování výpisu čísel

# %% [markdown]
# Bez další konfigurace funkce **print** vytiskne hodnotu proměnné a provede odřádkování. 

# %%
for a in range(1, 10):
    print(a)

# %% [markdown]
# Chování lze změnit pomocí direktivy **end** tak, že místo defaultního znaku **\n** je na konci výpisu vložena mezera.

# %%
for a in range(1, 10):
    print(a, end = " ")

# %% [markdown]
# Program lze dále vylepšit třeba tak, že po každém třetím čísle provedeme odřádkování funkcí **print()**

# %%
for a in range(1, 10):
    print(a, end = " ")
    if a == 3 or a == 6 or a == 9:
        print()

# %% [markdown]
# Minulé vylepšení je sice funkční, ale s rostoucím počtem čísel se stává logický výraz složitější. Poblém je ovšem možné zobecnit pomocí dělení modulo např. takto: proveď odřádkování tehdy, když je číslo dělitelné třema, tj. **a%3** je **0**, což odpovídá log. hodnotě **False**. Protože pro správnou funkci větvení je třeba logický výraz s hodnotou **True**, můžeme použít log. negaci. 

# %%
for a in range(1, 10):
    print(a, end = " ")
    if not (a % 3):
        print()


