# Tento program voláme s argumentem jméno souboru 
# Vypíše obsah souboru bez Pythonovských komentářů
# Řešení pomocí regulárních výrazů

import sys
import re

line_pattern=re.compile(r"([^#]*)(#.+)?\n")

def preskoc_komentare(f):
  # vytiskne obsah souboru 'f' s vynechanymi komentari
  for line in f.readlines(): # čte řádku po řádce
    print(line_pattern.fullmatch(line).group(1))
        
if __name__=="__main__":
  with open(sys.argv[1],'rt') as f: # otevři textový soubor
    preskoc_komentare(f)  # pokud se povedlo, preskakuj
  
