# Příklady na rozptylování
#
# Jan Kybic, 2016

import time

def hash_string(x,m):
  h=0
  for c in x:
    h=((h*67)+ord(c)) % m
  return h


def prvocisla_eratosthenes(m):
  """ Najdi prvočísla menší než m a vrať je v poli.
  Algoritmus Eratosthenova síta """

  primes=[]
  p=[True]*m #  p[i] = je 'i' prvočíslo?

  for i in range(2,m):
    if p[i]: # je to prvočíslo
      primes+=[i]
      j=2*i # označ j=2i,3i,... < m
      while j<m:
        p[j]=False
        j+=i
  return primes    

# save_primes lze použít pro vygenerování seznamu prvočísel, pokud je jich potřeba hodně
def save_primes(m=100000):
   """ uloží do souboru prvočísla do 'm' """

   f=open('primes.py','w')
   f.write("# Automaticky generovana prvocisla funkci save_primes\n")
   f.write("primes=")
   t=time.time()
   primes=prvocisla_eratosthenes(m)
   print("Generování prvočísel trvalo %6.1fs" % (time.time()-t))
   f.write(str(primes))
   f.write('\n')
   f.close()

# Následující řádka vygeneruje primes.py, který lze poté importovat
#primes=prvosave_primes(100000)   

# Najde prvočísla do 100000
primes=prvocisla_eratosthenes(100000)

def find_prime_size(n):
  """ Najde první prvočíslo větší než 'n'. Pokud takové v tabulce není,
  vrátí 'n' a vypíše varování. """
  for i in range(len(primes)):
    if primes[i]>n:
      return n
  print("Pozor, tabulka prvočísel je příliš krátká.")
  return n  

def find_index(l,x):
  """ Return index 'i' such that l[i]==x or 'None' if 'x' is not in 'l' """
  for i,v in enumerate(l):
    if v==x:
      return i
  return None

# Třída pro rozptylovací tabulku. Interface je záměrně stejný s binarysearchtree.BinarySearchTree  
class Hashtable:

  def __init__(self,n=13):           # 'n' je doporučená velikost
    self.size=find_prime_size(n)   # initial size
    self.keys  =[ [] for i in range(self.size) ]
    self.values=[ [] for i in range(self.size) ]
    self.count=0

def get(h,key):
  """ Vrátí 'value' prvku s klíčem 'key', jinak None """
  m=hash(key) % h.size      # číslo příhrádky
  i=find_index(h.keys[m],key) # je tam?
  if i is None:               # není
    return None
  return  h.values[m][i] 

def grow_table(h):
  """ Vytvoří větší tabulku, překopíruje tam obsah a vrátí ji """
  hnew=Hashtable(2*h.size)
  for i in range(h.size):     # okopíruj vše do hnew
    keys=h.keys[i]
    values=h.values[i]
    for j in range(len(keys)):
      put(hnew,keys[j],values[j])
  return hnew

def put(h,key,value):
    """ Vloží pár 'key'->'value' do stromu a vrátí odkaz na tabulku """
    m=hash(key) % h.size     # číslo příhrádky
    i=find_index(h.keys[m],key)    # je tam?
    if i is not None:              # klíč v tabulce už je     
      h.values[m][i]=value
      return h
    h.keys[m].append(key)             # klíč v tabulce není
    h.values[m].append(value)
    h.count+=1
    if h.count>h.size*0.75:       # je tabulka moc plná?
      return grow_table(h)
    return h

def items(h):
  """ Vrátí seznam dvojic klíč,hodnota """
  r=[]
  for i in range(h.size):
    r+=zip(h.keys[i],h.values[i])
  return list(r)

    
# ------------------------------------ Testing ----------------------------

def test_hash_string():
  print(hash_string("ahoj",113))
  print(hash_string("druhý",113))


def test_map():
  t=Hashtable()
  t=put(t,'pi',   3.14159)
  t=put(t,'e',    2.71828) 
  t=put(t,'sqrt2',1.41421)
  t=put(t,'golden',1.61803)
  print(get(t,'pi'))
  print(get(t,'e'))
  print(get(t,'gamma'))

if __name__=="__main__":
  test_map()
      
