<?php
class Auth {
    const SESSION_AUTH = "auth";
    private $user = null;
    private static $instance = null;
    
    public static function getInstance() {
        if (self::$instance == null) {
            self::$instance = new Auth();
        } 
        return self::$instance;
    }
    
    private function __construct() {
        if (isset($_SESSION[Auth::SESSION_AUTH])) {
            $this->user = $_SESSION[Auth::SESSION_AUTH];
        }
    }
    
    public function isLogged() {
          return ($this->user != null && $this->user->isActive());
    }
    
    public function logIn ($name, $passwd) {
        // zde by melo byt volani modelu, ktery overi v DB, zda dany
        // uzivatel existuje
        $this->user = DB_Model::getUser($name,$passwd);
        $_SESSION[Auth::SESSION_AUTH] = $this->user;
        if ($this->user == null) return false;
        return $this->user->isActive();
    }
    
    public function getUser() {
          return $this->user;
    }
    
    public function logOut() {
        $this->user = null;
        unset($_SESSION[Auth::SESSION_AUTH]);
    }
}
?>
