<?php

/**
 * @return bool Vraci true, pokud byl formular odeslat sam na sebe. False v pripade, ze byl nacten jako cerstvy formular.
 */

function isSubmittedForm() {
    return isset($_POST['odeslat']);
}

/**
 * Tato funkce zjisti, zda byl formular odeslan (sam na sebe) a zda je spravne vyplnen.
 * Pokud nebyl dosud odeslan, vrati prazdne pole.
 * Pokud byl odeslan, budou zkontrolovana vsechna pole s korektni vyplneni.
 * Jestlize bude nalezeno alespon jedno, ktere neni vyplneno spravne, bude toto zarazeno do vystupniho pole.
 * Vystupni pole je tedy seznam chyb, ktere byly nalezeny.
 */
function validate() {
    // zkontrokujeme, zda byl formular odeslat sam na sebe
    // zvolime si takove pole, ktere bylo s jistotou uspesne
    // napriklad tlacitko se jmenem "odeslat".

    $errors = array();

    if (isset($_POST['odeslat'])) {
        // ted ma cenu formular kontrolovat
        if (!isset($_POST['jmeno']) || trim($_POST['jmeno']) == "") {
            $errors['jmeno'] = "Jméno musí být vyplněné!";
        }

        if (!isset($_POST['prijmeni']) || trim($_POST['prijmeni']) == "") {
            $errors['prijmeni'] = "Příjmení musí být vyplněné!";
        }

        if (!isset($_POST['ulice']) || trim($_POST['ulice']) == "") {
            $errors['ulice'] = "Ulice musí být vyplněná!";
        }

        if (!isset($_POST['cislo']) || trim($_POST['cislo']) == "" || intval($_POST['cislo']) <= 0) {
            $errors['cislo'] = "Orientační číslo musí být vyplněné a musí to být číslo >= 1!";
        }

    } else {
        // formular byl nacten bez predchoziho odeslani
        // neni potreba nic kontrolovat
    }
    return $errors;
}

/**
 * @param $dataName Jmeno datoveho elementu.
 * @param $defaultValues Vychozi hodnoty.
 * @return string Vraci hodnotu atributu value pro element se zadanym jmenem. Hodnota je HTML bezpecna.
 */
function getFormTextData($dataName, $defaultValues) {
    if (isset($_POST[$dataName])) {
        $value = $_POST[$dataName];
    } else {
        if (isset($defaultValues[$dataName])) {
            $value = $defaultValues[$dataName];
        } else {
            $value = "";
        }
    }
    return htmlspecialchars($value);
}

/**
 * @param $dataName Jmeno datoveho elementu.
 * @param $defaultValues Pole vychozich hodnot. Pokud hodnota pro datovy element neni nastavena, vrati prazdny retezec.
 * @return string Vraci atribut checked. Pokud byl checkbox zaskrtnut, tak vrati checked="checked", jinak prazdny retezec.
 */
function getFormCheckboxData($dataName, $defaultValues) {
    if (isset($_POST[$dataName])) {
        return "checked=\"checked\"";
    } else {
        if (isset($defaultValues[$dataName]) && $defaultValues[$dataName]) {
            return "checked=\"checked\"";
        } else {
            return "";
        }
    }

}

/**
 * @param $dataName Jmeno datoveho elementu, ktery se bude kontrolovat
 * @param $errors Pole chyb, ktere ve formulari nastaly
 * @return string Vraci html chybovou tridu nebo prazdny retezec
 */
function errorClass($dataName, $errors) {
    if (isset($errors[$dataName])) {
        return " class = \"error\" ";
    }
}

/**
 * @param $dataName Jmeno datoveho elementu.
 * @param $errors Pole chyb ve formulari.
 * @return Vraci HTML bezpecnou hlasku, ktera prislusi chybe v elementu se zadanym jmenem. Pokud zadna chyba neni, vraci
 * prazdny retezec.
 */
function printMessage($dataName, $errors) {
    if (isset($errors[$dataName])) {
        return htmlspecialchars($errors[$dataName]);
    } else {
        return "";
    }
}
