<?php

/*
 * Tento formulář demonstruje, jak jednoduše zpracovat data z formuláře.
 * Ukázkový formulář obsahuje základní imformace, jako jsou jmeno, prijmeni, adresa,
 * stav (svobodný, ženatý/vdaná)
 */

include("helpers/form_functions.php");
include("models/data_functions.php");

// definuji vychozi hodnoty poli formulare


if (isSubmittedForm()) {
    $errors = validate();
    $data = array();
    if (sizeof($errors) > 0) {
        // formular byl odeslan, ale byly objeveny chyby, zpet na pohled formulare.
        include "views/formular.php";
    } else {
        // formular byl odeslan a nebyly objeveny zadne chyby
        // data by bylo dobre nejak zuzitkovat, napriklad zapsat do databaze
        insertOrUpdateStudent(
            $_POST["id"], $_POST['jmeno'], $_POST['prijmeni'],$_POST['ulice'], $_POST['cislo'], isset($_POST['zenaty'])
        );

        // muzeme tedy preskocit na jinou stranku.
        header("Location: thankyou.html");
    }
} else {
    // formular je poprve zobrazen.
    // pojdme se podivat, zda je nastaven atribut id a zda podle neho najdeme nejakeho studenta
    if (isset($_GET['id']) && ($data = getStudentById($_GET['id'])) != null) {
        // slava, povedlo se najit studenta s odpovidajicim id.
    } else {
        // studenta jsme nenasli

// nastavíme výchozí hodnoty data
        $data = array(
            "jmeno"    => "",
            "prijmeni" => "",
            "ulice"    => "",
            "cislo"    => "",
            "zenaty"   => false,
        );
    }
    $errors = array();
    include "views/formular.php";

}
