#include <iostream>
#include <string>
#include <memory>

class Writable {
public:
    virtual ~Writable() = default;
    virtual void write(std::ostream& out) const = 0;
};

class String : public Writable {
public:
    String(const std::string& str) : m_str(str) {}
    virtual ~String() override = default;
    virtual void write(std::ostream& out) const override { out << m_str << '\n'; }
private:
    std::string m_str;
};

class Number : public Writable {
public:
    Number(double num) : m_num(num) {}
    virtual ~Number() override = default;
    virtual void write(std::ostream& out) const override { out << m_num << '\n'; }
private:
    double m_num;
};

int main() {
    std::unique_ptr<Writable> str1(new String("abc"));
    std::unique_ptr<Writable> str2(new String("def"));
    std::unique_ptr<Writable> num1(new Number(123));
    std::unique_ptr<Writable> num2(new Number(456));
    
    str1->write(std::cout);
    str2->write(std::cout);
    num1->write(std::cout);
    num2->write(std::cout);
}
