#pragma once
#include <cstddef>
#include <memory>
#include <iosfwd>
#include <iterator>

using std::size_t;

class vector {
public:
    vector();
    vector(size_t sz, double val);

    vector(const vector& rhs);
    vector(vector&& rhs);
    vector& operator=(const vector& rhs);
    vector& operator=(vector&& rhs);

    void reserve(size_t cap);
    void resize(size_t sz, double val = 0);
    void push_back(double val);
    void pop_back();
    size_t size() const;
    size_t capacity() const;
    void clear();
    void swap(vector& rhs);

    double& at(size_t i);
    double at(size_t i) const;
    double& operator[](size_t i);
    double operator[](size_t i) const;

    class iterator {
    public:
        using iterator_category = std::bidirectional_iterator_tag;
        using difference_type = std::ptrdiff_t;
        using value_type = double;
        using reference = double&;
        using pointer = double*;

        iterator() = default;
        iterator(const iterator&) = default;
        iterator(double* d) : ptr(d) {}
        iterator& operator++() { ++ptr; return *this; }
        iterator& operator--() { --ptr; return *this; }
        double* operator->() { return ptr; }
        double& operator*() { return *ptr; }
        bool operator==(const iterator& rhs) const { return ptr == rhs.ptr; }
        bool operator!=(const iterator& rhs) const { return ptr != rhs.ptr; }

        iterator operator++(int) {
            iterator temp(*this);
            ++*this;
            return temp;
        }

        iterator operator--(int) {
            iterator temp(*this);
            --*this;
            return temp;
        }
    private:
        double* ptr;
    };

    using const_iterator = const double*;

    iterator begin() { return iterator(m_data.get()); }
    iterator end() { return iterator(m_data.get() + m_size); }
    const_iterator begin() const { return const_iterator(m_data.get()); }
    const_iterator end() const { return const_iterator(m_data.get() + m_size); }

private:
    std::unique_ptr<double[]> m_data;
    size_t m_capacity;
    size_t m_size;
};

std::ostream& operator<<(std::ostream& out, const vector& v);
