#include "vector.hpp"
#include <iostream>

void multiply_all(vector& v, double factor) {
    for (auto& elem : v) {
        elem *= factor;
    }
}

double accumulate(const vector& v) {
    double sum = 0;

    for (auto const& elem : v) {
        sum += elem;
    }

    return sum;
}

vector cat(vector v) {
    auto original_size = v.size();
    v.resize(v.size() * 2);
    for (size_t i = 0; i < original_size; ++i) {
        v[original_size + i] = v[i];
    }
    return v;
}

int main() {
    vector v;
    v.push_back(1.23);
    v.push_back(2.34);
    v.push_back(3.45);
    std::cout << v;             // 1.23 2.34 3.45
    multiply_all(v, 2);
    std::cout << v;             // 2.46 4.68 6.9
    double sum = accumulate(v);
    std::cout << sum << '\n';   // 14.04
    v = cat(v);
    std::cout << v;             // 2.46 4.68 6.9 2.46 4.68 6.9
}
