#include "vector.hpp"
#include <iostream>

void multiply_all(vector& v, double factor) {
    for (size_t i = 0; i < size(v); i++) {
        at(v, i) *= factor;
    }
}

double accumulate(const vector& v) {
    double sum = 0;

    for (size_t i = 0; i < size(v); i++) {
        sum += at(v, i);
    }

    return sum;
}

void print_vector(const vector& v) {
    std::cout << "capacity: " << capacity(v) << " size: " << size(v) << " data: ";
    
    for (size_t i = 0; i < size(v); i++) {
        std::cout << at(v, i) << ' ';
    }
    std::cout << '\n';
}

int main() {
    vector v;
    push_back(v, 1.23);
    push_back(v, 2.34);
    push_back(v, 3.45);
    print_vector(v);            // capacity: 6 size: 3 data: 1.23 2.34 3.45
    resize(v, 5);
    at(v, 3) = 3.14;
    multiply_all(v, 2);
    print_vector(v);            // capacity: 6 size: 5 data: 2.46 4.68 6.9 6.28 0
    double sum = accumulate(v);
    std::cout << sum << '\n';   // 20.32
    clear(v);
    print_vector(v);            // capacity: 6 size: 0 data:
    dispose(v);
}
