#pragma once
#include <cstddef>
using std::size_t;

struct vector {
    double* m_data = nullptr;
    size_t m_capacity = 0;
    size_t m_size = 0;
};

void dispose(vector& v);
void reserve(vector& v, size_t capacity);
void push_back(vector& v, double val);
void pop_back(vector& v);
size_t size(const vector& v);
size_t capacity(const vector& v);
void clear(vector& v);
double& at(vector& v, size_t i);
double at(const vector& v, size_t i);
void resize(vector& v, size_t size, double value = 0);
