#include "vector.hpp"
#include "array.hpp"

#include <algorithm>

void dispose(vector& v) {
    delete[] v.m_data;
}

void reserve(vector& v, size_t capacity) {
    if (v.m_capacity < capacity) {
        resize_array(v.m_data, v.m_size, capacity);
        v.m_capacity = capacity;
    }
}

void push_back(vector& v, double val) {
    if (v.m_size == v.m_capacity) {
        reserve(v, (v.m_capacity + 1) * 2);
    }

    v.m_data[v.m_size] = val;
    v.m_size++;
}

void pop_back(vector& v) {
    v.m_size--;
}

size_t size(const vector& v) {
    return v.m_size;
}

size_t capacity(const vector& v) {
    return v.m_capacity;
}

void clear(vector& v) {
    v.m_size = 0;
}

double& at(vector& v, size_t i) {
    return v.m_data[i];
}

double at(const vector& v, size_t i) {
    return v.m_data[i];
}

void resize(vector& v, size_t size, double value) {
    if (size >= v.m_size) {
        reserve(v, size);
        std::fill(v.m_data + v.m_size, v.m_data + size, value);
    }

    v.m_size = size;
}
