#include <iostream>

enum class Mesic {
    leden = 1,
    unor,
    brezen,
    duben,
    kveten,
    cerven,
    cervenec,
    srpen,
    zari,
    rijen,
    listopad,
    prosinec
};

void vypis(std::ostream& out, Mesic m) {
    int cislo = static_cast<int>(m);
    out << cislo << '.';
}

Mesic dalsiMesic(Mesic m) {
    if (m == Mesic::prosinec) return Mesic::leden;
    int cislo = static_cast<int>(m);
    Mesic ret = static_cast<Mesic>(cislo + 1);
    return ret;
}

Mesic predchoziMesic(Mesic m) {
    if (m == Mesic::leden) return Mesic::prosinec;
    int cislo = static_cast<int>(m);
    Mesic ret = static_cast<Mesic>(cislo - 1);
    return ret;
}

struct Datum {
    int den;
    Mesic mesic;
    int rok;
};

void vypis(std::ostream& out, const Datum& d) {
    out << d.den << ". ";
    vypis(out, d.mesic);
    out << ' ' << d.rok;
}

int pocetDni(Mesic m, int rok) {
    switch (m) {
    case Mesic::leden:
    case Mesic::brezen:
    case Mesic::kveten:
    case Mesic::cervenec:
    case Mesic::srpen:
    case Mesic::rijen:
    case Mesic::prosinec:
        return 31;
    case Mesic::duben:
    case Mesic::cerven:
    case Mesic::zari:
    case Mesic::listopad:
        return 30;
    case Mesic::unor:
        if (rok % 400 == 0) return 29;
        if (rok % 100 == 0) return 28;
        if (rok % 4 == 0) return 29;
        return 28;
    }
}

int pocetDni(int rok) {
    return (7 * 31 + 4 * 30) + pocetDni(Mesic::unor, rok);
}

void pridejRok(Datum& d, int pocet = 1) {
    d.rok += pocet;
}

void pridejMesic(Datum& d, int pocet = 1) {
    if (pocet > 0) {
        for (; pocet != 0; pocet--) {
            if (d.mesic == Mesic::prosinec) pridejRok(d, 1);
            d.mesic = dalsiMesic(d.mesic);
        }
    }
    else {
        for (; pocet != 0; pocet++) {
            if (d.mesic == Mesic::leden) pridejRok(d, -1);
            d.mesic = predchoziMesic(d.mesic);
        }
    }
}

void pridejDen(Datum& d, int pocet = 1) {
    if (pocet > 0) {
        for (; pocet != 0; pocet--) {
            if (d.den == pocetDni(d.mesic, d.rok)) {
                d.den = 1;
                pridejMesic(d, 1);
            }
            else d.den++;
        }
    }
    else {
        for (; pocet != 0; pocet++) {
            if (d.den == 1) {
                pridejMesic(d, -1);
                d.den = pocetDni(d.mesic, d.rok);
            }
            else d.den--;
        }
    }
}

int main() {
    Mesic m1 = Mesic::leden;
    Mesic m2 = Mesic::prosinec;

    vypis(std::cout, m1);
    std::cout << '\n';
    vypis(std::cout, m2);
    std::cout << '\n';

    vypis(std::cout, dalsiMesic(m1));
    std::cout << '\n';
    vypis(std::cout, dalsiMesic(m2));
    std::cout << '\n';

    vypis(std::cout, predchoziMesic(m1));
    std::cout << '\n';
    vypis(std::cout, predchoziMesic(m2));
    std::cout << '\n';

    std::cout << "pocet dni v 2016: " << pocetDni(2016) << '\n';
    std::cout << "pocet dni v 2017: " << pocetDni(2017) << '\n';

    Datum d1 = { 9, Mesic::brezen, 2016 };

    vypis(std::cout, d1);
    std::cout << '\n';

    pridejDen(d1, 1);
    vypis(std::cout, d1);
    std::cout << '\n';

    pridejDen(d1, 10);
    vypis(std::cout, d1);
    std::cout << '\n';

    pridejDen(d1, 100);
    vypis(std::cout, d1);
    std::cout << '\n';

    pridejDen(d1, 1000);
    vypis(std::cout, d1);
    std::cout << '\n';
}
