#include "image.hpp"
#include "timer.hpp"
#include <iostream>
#include <string>

int main(int argc, char** argv) {
    if (argc < 3) return 1;
    double low = std::stoi(argv[1]);
    double high = std::stoi(argv[2]);
    Image in = loadImage("in.png");
    
    Image out;
    out.data.resize(in.data.size());
    out.width = in.width;
    out.height = in.height;

    auto startTime = timer::now();

    for (int retry = 0; retry < 1000; retry++) {
        unsigned char table[256];
        for (int i = 0; i < 256; i++) {
            double res = 256.0 * (static_cast<double>(i) - low) / (high - low);
            if (res < 0) res = 0;
            if (res > 255) res = 255;
            table[i] = static_cast<unsigned char>(res);
        }

        auto pIn = in.data.begin();
        auto pEnd = in.data.end();
        auto pOut = out.data.begin();

        while (pIn != pEnd) {
            *pOut++ = table[*pIn++];
            *pOut++ = table[*pIn++];
            *pOut++ = table[*pIn++];
            *pOut++ = *pIn++;
        }
    }

    std::cout << timer::to_ms(timer::now() - startTime) << " ms\n";
    saveImage(out, "out.png");
}
