#include "image.hpp"
#include "timer.hpp"
#include <iostream>
#include <string>

int main(int argc, char** argv) {
    if (argc < 3) return 1;
    unsigned char low = std::stoi(argv[1]);
    unsigned char high = std::stoi(argv[2]);
    Image in = loadImage("in.png");
    
    Image out;
    out.data.resize(in.data.size());
    out.width = in.width;
    out.height = in.height;

    auto startTime = timer::now();

    for (int retry = 0; retry < 1000; retry++) {
        for (int i = 0; i < in.data.size(); i += 4) {
            double r = in.data[i + 0];
            double g = in.data[i + 1];
            double b = in.data[i + 2];
            double a = in.data[i + 3];

            r = 255.0 * ((r - low) / (high - low));
            g = 255.0 * ((g - low) / (high - low));
            b = 255.0 * ((b - low) / (high - low));

            if (r < 0) r = 0;
            if (g < 0) g = 0;
            if (b < 0) b = 0;
            if (r > 255) r = 255;
            if (g > 255) g = 255;
            if (b > 255) b = 255;

            out.data[i + 0] = static_cast<unsigned char>(r);
            out.data[i + 1] = static_cast<unsigned char>(g);
            out.data[i + 2] = static_cast<unsigned char>(b);
            out.data[i + 3] = static_cast<unsigned char>(a);
        }
    }

    std::cout << timer::to_ms(timer::now() - startTime) << " ms\n";
    saveImage(out, "out.png");
}
