package cz.cvut.kbss.jakarta.hello;

import jakarta.servlet.*;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpServletResponse;

import java.io.IOException;

@WebFilter(servletNames = "hw")
public class LocalhostServletFilter implements Filter {

  @Override
  public void init(FilterConfig filterConfig) {
    System.out.println("Initializing the filter " + getClass().getName());
  }

  @Override
  public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse,
                       FilterChain filterChain) throws IOException, ServletException {
    System.out.println("Filtering using the filter " + getClass().getName());
    final String addr = servletRequest.getLocalAddr();
    if (addr.matches("0:0:0:0:0:0:0:1")) {
      System.out.println("- match, continuing.");
      filterChain.doFilter(servletRequest, servletResponse);
    } else {
      ((HttpServletResponse) servletResponse).sendError(HttpServletResponse.SC_FORBIDDEN, "You are not authorized for this operation.");
    }
  }

  @Override
  public void destroy() {
  }
}
