package cz.cvut.kbss.jakarta.hello;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebInitParam;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

import java.io.IOException;

@WebServlet(name = "hw",
        urlPatterns = {"/hello/*"}, initParams = {
        @WebInitParam(name = "brand", value = "KBSS"),
})
public class HelloWorldServlet extends HttpServlet {

  private static int count = 0;

  public void init(ServletConfig config) throws ServletException {
    super.init(config);
    System.out.println("This servlet has been created by " + getInitParameter("brand"));
  }

  protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
    final String accept = req.getHeader("Accept");

    final String me = req.getParameter("name");

    if (accept != null && accept.equals("application/json")) {
      resp.setContentType("text/json");
      resp.getWriter().write("{ \"message\" : \"hello " + me + "\", \"count\" : \"" + count + "\"}");
    } else {
      resp.setContentType("text/plain");
      resp.getWriter().write("Greetings " + me + ", count=" + count + ",\n\n(C) " + getInitParameter("brand"));
    }
    count++;
  }

  public void destroy() {
    super.destroy();
    System.out.println("This servlet is closing down.");
  }
}