// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Actor.h"
#include "SingleParticle.generated.h"

DECLARE_LOG_CATEGORY_EXTERN(SingleParticle, All, All);

UCLASS()
class LENNARDJONESPLUGIN_API ASingleParticle : public AActor
{
	GENERATED_BODY()
	
public:	
	// Sets default values for this actor's properties
	ASingleParticle();

protected:
	// Called when the game starts or when spawned
	virtual void BeginPlay() override;

public:	
	// Called every frame
	virtual void Tick(float DeltaTime) override;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="Particle Settings")
	double ParticleMass = 1.0;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="Particle Settings")
	bool bUseForceForColor = false;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="Particle Settings")
	FName CollisionProfileName;
	
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="Particle Settings|Simulation")
	double Sigma = 200.0;
	
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="Particle Settings|Simulation")
	double Epsilon = 10000.0;

private:
	TObjectPtr<UStaticMeshComponent> StaticMeshComponent;
	TObjectPtr<UMaterialInstanceDynamic> MaterialInstance;
	TObjectPtr<UMaterial> BaseMaterial;
};
