// Fill out your copyright notice in the Description page of Project Settings.


#include "SingleParticle.h"

#include "EngineUtils.h"
#include "SimulationFunctions.h"

DEFINE_LOG_CATEGORY(SingleParticle);

// Sets default values
ASingleParticle::ASingleParticle()
{
 	// Set this actor to call Tick() every frame.  You can turn this off to improve performance if you don't need it.
	PrimaryActorTick.bCanEverTick = true;

	StaticMeshComponent = CreateDefaultSubobject<UStaticMeshComponent>(TEXT("Static Mesh Component"));
	RootComponent = StaticMeshComponent;

	UStaticMesh* Mesh = ConstructorHelpers::FObjectFinder<UStaticMesh>(TEXT("/Script/Engine.StaticMesh'/Engine/BasicShapes/Sphere.Sphere'")).Object;
	StaticMeshComponent->SetStaticMesh(Mesh);
	StaticMeshComponent->SetSimulatePhysics(true);
	StaticMeshComponent->SetEnableGravity(false);
	StaticMeshComponent->SetMassOverrideInKg(NAME_None, ParticleMass);
	StaticMeshComponent->SetCollisionProfileName(CollisionProfileName);
	StaticMeshComponent->SetWorldScale3D(FVector(0.3));

	BaseMaterial = ConstructorHelpers::FObjectFinder<UMaterial>(TEXT("/Script/Engine.Material'/LennardJonesPlugin/Materials/M_VelocityBased.M_VelocityBased'")).Object;
	StaticMeshComponent->SetMaterial(0, BaseMaterial);
}

// Called when the game starts or when spawned
void ASingleParticle::BeginPlay()
{
	MaterialInstance = UMaterialInstanceDynamic::Create(BaseMaterial, StaticMeshComponent);
	StaticMeshComponent->SetMaterial(0, MaterialInstance);
	
	Super::BeginPlay();
}

// Called every frame
void ASingleParticle::Tick(float DeltaTime)
{
	Super::Tick(DeltaTime);

	TObjectPtr<UWorld> World = GetWorld(); 

	FVector TotalForce(0);
	for (TActorIterator<ASingleParticle> It(World); It; ++It)
	{
		// Skip this particle
		if (It->GetUniqueID() == this->GetUniqueID())
		{
			continue;
		}

		auto Location = It->GetActorLocation();
		auto SelfLocation = GetActorLocation();
		auto Distance = Location - SelfLocation;

		double LJForce = LennardJonesForce(Distance.Size(), Epsilon, Sigma);
		TotalForce += LJForce * Distance.GetSafeNormal();
	}
	StaticMeshComponent->AddForce(TotalForce);

	if (bUseForceForColor)
	{
		MaterialInstance->SetScalarParameterValue(TEXT("Velocity"), TotalForce.Length());
	}
	else
	{
		const FVector Velocity = StaticMeshComponent->GetPhysicsLinearVelocity();
		MaterialInstance->SetScalarParameterValue(TEXT("Velocity"), Velocity.Length());
	}
}

