#include "SimulationFunctions.h"

double LennardJonesForce(double Distance, double Epsilon, double Sigma)
{
	// This following equation describes the Lennard-Jones potential as seen
	// in the lecture slides.
	// V = 4 * Epsilon * ((Sigma / Distance)^12 - (Sigma / Distance)^6)
	// However to get an actual force acting on our particles, we need to derive
	// this equation by Distance and negate it. The resulting equation follows.
	double Sigma6 = pow(Sigma, 6);
	double Distance6 = pow(Distance, 6);
	double Distance13 = pow(Distance, 13);
	double Force = (24 * Sigma6 * Epsilon * (Distance6 - 2 * Sigma6)) / Distance13;

	return Force;
}
