


#include "Brick.h"

#include "Kismet/GameplayStatics.h"

// Sets default values
ABrick::ABrick()
{
	// Set this actor to call Tick() every frame.  You can turn this off to improve performance if you don't need it.
	PrimaryActorTick.bCanEverTick = true;

	TObjectPtr<UStaticMeshComponent> MeshComponent = GetStaticMeshComponent();

	// TODO: Construct a static mesh for our brick, ensure it is movable

	// TODO: Enable physics, disable gravity and optionally set damping factors

	// TODO: Override mass to be 1 Kg instead of volume-based calculation

	// Get the class of our arrow indicator
	ArrowClass = ConstructorHelpers::FClassFinder<AActor>(TEXT("/Game/Blueprints/BP_Arrow")).Class;
}

void ABrick::ApplyLeftForce(float Scale)
{
	ApplyForce(Scale, {-100.f, 100.f, 0.f});
}

void ABrick::ApplyRightForce(float Scale)
{
	ApplyForce(Scale, {-100.f, -100.f, 0.f});
}

// Called when the game starts or when spawned
void ABrick::BeginPlay()
{
	Super::BeginPlay();
	
}

void ABrick::ApplyForce(float Scale, FVector Location)
{
	// First apply the scaled force at the selected location.
	// This will likely make the brick rotate as well as translate.
	
	// TODO: Use AddForceAtLocation on this Actor's static mesh to apply a *forward* force at the given location.

	// Then spawn an arrow to indicate where the force was applied.
	// Make sure to rotate the arrow according to the object's rotation
	// (the force is always applied in a single direction, the forward direction of the object).
	FTransform ArrowTransform;
	ArrowTransform.SetLocation(GetActorLocation() + GetActorRotation().Quaternion().RotateVector(Location));
	ArrowTransform.SetRotation(GetActorRotation().Quaternion());
	GetWorld()->SpawnActor(ArrowClass, &ArrowTransform);
}

// Called every frame
void ABrick::Tick(float DeltaTime)
{
	Super::Tick(DeltaTime);

	// We can handle player input here (or we could tie our functions using the level blueprint).
	// Ideally, we would have a pawn with a player controller. However for our use case for controlling
	// a simulation, just checking if out input key is pressed will suffice. This can be achieved using
	// The UGameplayStatics class.
	// Example:
	//UGameplayStatics::GetPlayerController(GetWorld(), 0)->IsInputKeyDown(EKeys::U)

	// TODO: Implement input either here or using a level blueprint.
}

