#include "stm32f4xx.h"
#include "stm32f4xx_hal.h"

#define I2C_ADDRESS 	0x27<<1

I2C_HandleTypeDef I2cHandle;

static void SystemClock_Config(void){
    RCC_ClkInitTypeDef RCC_ClkInitStruct;
    RCC_OscInitTypeDef RCC_OscInitStruct;

    __HAL_PWR_VOLTAGESCALING_CONFIG(PWR_REGULATOR_VOLTAGE_SCALE1);
    RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI;
    RCC_OscInitStruct.HSEState = RCC_HSE_OFF;
    RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
    RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSE;
    RCC_OscInitStruct.PLL.PLLM = 16;
    RCC_OscInitStruct.PLL.PLLN = 336;
    RCC_OscInitStruct.PLL.PLLP = RCC_PLLP_DIV2;
    RCC_OscInitStruct.PLL.PLLQ = 7;
    HAL_RCC_OscConfig(&RCC_OscInitStruct);
    RCC_ClkInitStruct.ClockType =
        (RCC_CLOCKTYPE_SYSCLK | RCC_CLOCKTYPE_HCLK |
         RCC_CLOCKTYPE_PCLK1 | RCC_CLOCKTYPE_PCLK2);
    RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
    RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
    RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV4;
    RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV2;
    HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_5);
}

// Inicializace I2C1
void configI2C1 (void) {

    GPIO_InitTypeDef GPIO_InitStruct;

    __HAL_RCC_I2C1_CLK_ENABLE();

    // konfigurace samotneho I2C1
    // 100kHz, 7bit adresa
    I2cHandle.Instance = I2C1;
    I2cHandle.Init.ClockSpeed = 100000;
    I2cHandle.Init.DutyCycle = I2C_DUTYCYCLE_2;
    I2cHandle.Init.OwnAddress1 = 0;
    I2cHandle.Init.AddressingMode = I2C_ADDRESSINGMODE_7BIT;
    I2cHandle.Init.DualAddressMode = I2C_DUALADDRESS_DISABLE;
    I2cHandle.Init.OwnAddress2 = 0;
    I2cHandle.Init.GeneralCallMode = I2C_GENERALCALL_DISABLE;
    I2cHandle.Init.NoStretchMode = I2C_NOSTRETCH_DISABLE;
    HAL_I2C_Init(&I2cHandle);


    /*******************************
    Nastaveni I2C1 GPIO
        PB8     ------> I2C1_SCL
        PB9     ------> I2C1_SDA
    *******************************/

    __HAL_RCC_GPIOB_CLK_ENABLE();

    GPIO_InitStruct.Pin = GPIO_PIN_8|GPIO_PIN_9;
    GPIO_InitStruct.Mode = GPIO_MODE_AF_OD;
    GPIO_InitStruct.Pull = GPIO_PULLUP;
    GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_VERY_HIGH;
    GPIO_InitStruct.Alternate = GPIO_AF4_I2C1;
    HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);
}

int main(void)
{
  int i = 0;

  HAL_Init();
  SystemClock_Config();
  configI2C1();

  while (1){
	char data_write[8];
	char data_read[8];
	data_write[0] = 0;
	data_write[1] = i++;

	// prikaz na odeslani dat
	HAL_I2C_Master_Transmit(&I2cHandle, I2C_ADDRESS, (uint8_t*) data_write, 2, 5);
	// prikaz na prijem dat
	//HAL_I2C_Master_Receive(&I2cHandle, I2C_ADDRESS, (uint8_t*) data_read, 2, 5);
	HAL_Delay(200);
  }
}
