-- Copyright (C) 2017  Intel Corporation. All rights reserved.
-- Your use of Intel Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Intel Program License 
-- Subscription Agreement, the Intel Quartus Prime License Agreement,
-- the Intel FPGA IP License Agreement, or other applicable license
-- agreement, including, without limitation, that your use is for
-- the sole purpose of programming logic devices manufactured by
-- Intel and sold by Intel or its authorized distributors.  Please
-- refer to the applicable agreement for further details.

-- Generated by Quartus Prime Version 17.1.0 Build 590 10/25/2017 SJ Lite Edition
-- Created on Tue Oct 31 10:31:33 2023

LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY fsmsemaphore IS
    PORT (
        reset : IN STD_LOGIC := '0';
        clock : IN STD_LOGIC;
        timer16done : IN STD_LOGIC := '0';
        button : IN STD_LOGIC := '0';
        timer4done : IN STD_LOGIC := '0';
        timeren : OUT STD_LOGIC;
        l_red : OUT STD_LOGIC;
        l_orange : OUT STD_LOGIC;
        l_green : OUT STD_LOGIC;
        l_btn : OUT STD_LOGIC;
        timerfast : OUT STD_LOGIC;
        timerrst : OUT STD_LOGIC
    );
END fsmsemaphore;

ARCHITECTURE BEHAVIOR OF fsmsemaphore IS
    TYPE type_fstate IS (Green,WAITTIME,WAITTIMEQUICK,ORANGE,RED,ORANGERED);
    SIGNAL fstate : type_fstate;
    SIGNAL reg_fstate : type_fstate;
BEGIN
    PROCESS (clock,reg_fstate)
    BEGIN
        IF (clock='1' AND clock'event) THEN
            fstate <= reg_fstate;
        END IF;
    END PROCESS;

    PROCESS (fstate,reset,timer16done,button,timer4done)
    BEGIN
        IF (reset='1') THEN
            reg_fstate <= Green;
            timeren <= '0';
            l_red <= '0';
            l_orange <= '0';
            l_green <= '0';
            l_btn <= '0';
            timerfast <= '0';
            timerrst <= '0';
        ELSE
            timeren <= '0';
            l_red <= '0';
            l_orange <= '0';
            l_green <= '0';
            l_btn <= '0';
            timerfast <= '0';
            timerrst <= '0';
            CASE fstate IS
                WHEN Green =>
                    reg_fstate <= WAITTIME;

                    timerrst <= '1';

                    l_green <= '1';
                WHEN WAITTIME =>
                    IF (((button = '1') AND (timer16done = '0'))) THEN
                        reg_fstate <= WAITTIMEQUICK;
                    ELSIF ((timer16done = '1')) THEN
                        reg_fstate <= ORANGE;
                    -- Inserting 'else' block to prevent latch inference
                    ELSE
                        reg_fstate <= WAITTIME;
                    END IF;

                    timeren <= '1';

                    timerfast <= '0';

                    l_green <= '1';
                WHEN WAITTIMEQUICK =>
                    IF ((timer16done = '1')) THEN
                        reg_fstate <= ORANGE;
                    -- Inserting 'else' block to prevent latch inference
                    ELSE
                        reg_fstate <= WAITTIMEQUICK;
                    END IF;

                    timeren <= '1';

                    l_btn <= '1';

                    timerfast <= '1';

                    l_green <= '1';
                WHEN ORANGE =>
                    IF ((timer4done = '1')) THEN
                        reg_fstate <= RED;
                    -- Inserting 'else' block to prevent latch inference
                    ELSE
                        reg_fstate <= ORANGE;
                    END IF;

                    timeren <= '1';

                    timerfast <= '0';

                    l_orange <= '1';
                WHEN RED =>
                    IF ((timer16done = '1')) THEN
                        reg_fstate <= ORANGERED;
                    -- Inserting 'else' block to prevent latch inference
                    ELSE
                        reg_fstate <= RED;
                    END IF;

                    l_red <= '1';

                    timeren <= '1';
                    timeren <= '1';

                    timerfast <= '1';
                WHEN ORANGERED =>
                    IF ((timer4done = '1')) THEN
                        reg_fstate <= Green;
                    -- Inserting 'else' block to prevent latch inference
                    ELSE
                        reg_fstate <= ORANGERED;
                    END IF;

                    l_red <= '1';

                    timeren <= '1';

                    timerfast <= '0';

                    l_orange <= '1';
                WHEN OTHERS => 
                    timeren <= 'X';
                    l_red <= 'X';
                    l_orange <= 'X';
                    l_green <= 'X';
                    l_btn <= 'X';
                    timerfast <= 'X';
                    timerrst <= 'X';
                    report "Reach undefined state";
            END CASE;
        END IF;
    END PROCESS;
END BEHAVIOR;
