-- Copyright (C) 2017  Intel Corporation. All rights reserved.
-- Your use of Intel Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files from any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Intel Program License 
-- Subscription Agreement, the Intel Quartus Prime License Agreement,
-- the Intel FPGA IP License Agreement, or other applicable license
-- agreement, including, without limitation, that your use is for
-- the sole purpose of programming logic devices manufactured by
-- Intel and sold by Intel or its authorized distributors.  Please
-- refer to the applicable agreement for further details.

-- Generated by Quartus Prime Version 17.1.0 Build 590 10/25/2017 SJ Lite Edition
-- Created on Tue Oct 18 22:01:45 2022

LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY state_machine IS
    PORT (
        clock : IN STD_LOGIC;
        reset : IN STD_LOGIC := '0';
        sync : IN STD_LOGIC := '0';
        counter : IN STD_LOGIC_VECTOR(5 DOWNTO 0) := "000000";
        clk : OUT STD_LOGIC;
        load : OUT STD_LOGIC;
        strobe : OUT STD_LOGIC;
        reset_counter : OUT STD_LOGIC
    );
END state_machine;

ARCHITECTURE BEHAVIOR OF state_machine IS
    TYPE type_fstate IS (sync_wait,load_l,load_h,clk_l,clk_h,strobe_h,strobe_l);
    SIGNAL fstate : type_fstate;
    SIGNAL reg_fstate : type_fstate;
BEGIN
    PROCESS (clock,reg_fstate)
    BEGIN
        IF (clock='1' AND clock'event) THEN
            fstate <= reg_fstate;
        END IF;
    END PROCESS;

    PROCESS (fstate,reset,sync,counter)
    BEGIN
        IF (reset='1') THEN
            reg_fstate <= sync_wait;
            clk <= '0';
            load <= '0';
            strobe <= '0';
            reset_counter <= '0';
        ELSE
            clk <= '0';
            load <= '0';
            strobe <= '0';
            reset_counter <= '0';
            CASE fstate IS
                WHEN sync_wait =>
                    IF ((sync = '1')) THEN
                        reg_fstate <= load_h;
                    ELSIF ((sync = '0')) THEN
                        reg_fstate <= sync_wait;
                    -- Inserting 'else' block to prevent latch inference
                    ELSE
                        reg_fstate <= sync_wait;
                    END IF;

                    IF ((sync = '0')) THEN
                        reset_counter <= '1';
                    ELSIF ((sync = '1')) THEN
                        reset_counter <= '0';
                    -- Inserting 'else' block to prevent latch inference
                    ELSE
                        reset_counter <= '0';
                    END IF;
                WHEN load_l =>
                    IF ((counter(5 DOWNTO 0) = "000010")) THEN
                        reg_fstate <= clk_l;
                    -- Inserting 'else' block to prevent latch inference
                    ELSE
                        reg_fstate <= load_l;
                    END IF;

                    load <= '0';
                WHEN load_h =>
                    IF ((counter(5 DOWNTO 0) = "000001")) THEN
                        reg_fstate <= load_l;
                    -- Inserting 'else' block to prevent latch inference
                    ELSE
                        reg_fstate <= load_h;
                    END IF;

                    load <= '1';
                WHEN clk_l =>
                    IF ((counter(5 DOWNTO 0) < "010011")) THEN
                        reg_fstate <= clk_h;
                    ELSIF ((counter(5 DOWNTO 0) = "010011")) THEN
                        reg_fstate <= strobe_h;
                    -- Inserting 'else' block to prevent latch inference
                    ELSE
                        reg_fstate <= clk_l;
                    END IF;

                    clk <= '0';
                WHEN clk_h =>
                    IF ((counter(5 DOWNTO 0) < "010100")) THEN
                        reg_fstate <= clk_l;
                    -- Inserting 'else' block to prevent latch inference
                    ELSE
                        reg_fstate <= clk_h;
                    END IF;

                    clk <= '1';
                WHEN strobe_h =>
                    IF ((counter(5 DOWNTO 0) = "010100")) THEN
                        reg_fstate <= strobe_l;
                    -- Inserting 'else' block to prevent latch inference
                    ELSE
                        reg_fstate <= strobe_h;
                    END IF;

                    strobe <= '1';
                WHEN strobe_l =>
                    IF ((counter(5 DOWNTO 0) = "010101")) THEN
                        reg_fstate <= sync_wait;
                    -- Inserting 'else' block to prevent latch inference
                    ELSE
                        reg_fstate <= strobe_l;
                    END IF;

                    strobe <= '0';
                WHEN OTHERS => 
                    clk <= 'X';
                    load <= 'X';
                    strobe <= 'X';
                    reset_counter <= 'X';
                    report "Reach undefined state";
            END CASE;
        END IF;
    END PROCESS;
END BEHAVIOR;
