#include "lcd1602a.h"

// define pins for LCD
static const adsPin_t lcdpins[] =
{
  {lcdD4, GPIOB,  5},
  {lcdD5, GPIOB,  4},
  {lcdD6, GPIOB, 10},
  {lcdD7, GPIOA,  8},
  {lcdRS, GPIOA,  9},
  {lcdE,  GPIOC,  7},
};

uint8_t ucaDispData[2][16];

void lcd_sendData4(uint8_t ucData)
{
  /* TODO: Nastavte LCD_D[7..4] piny a poslete prikaz */
  gpio_pinset(lcdD7, 0);  // template

  gpio_pinset(lcdE, 1);
  lcd_delay();
  gpio_pinset(lcdE, 0);
  lcd_delay();
}

void lcd_sendCmd(uint8_t ucCmd)
{
  /* TODO: Poslete 8 bitovy prikaz pres 4 bitovou sbernici */
  // RS = 0
}

void lcd_sendData(uint8_t ucData)
{
  /* TODO: Poslete 8 bitova data pres 4 bitovou sbernici */
  // RS = 1
}

void lcd_sendText(char *text)
{
  while(*text){
	  lcd_sendData(*text++);
  }
}

void gpio_pinset(enmLCDPins_t pin, uint32_t value)
{
  if(value)
  {
    lcdpins[pin].pgpio->BSRR |= 1 << lcdpins[pin].pin;
  }
  else
  {
    lcdpins[pin].pgpio->BSRR |= (1 << lcdpins[pin].pin) << 16;
  }
}

void lcd_delay(void){	// approx 1ms
	for(volatile int i=0; i<500; i++);
}

void lcd_init_gpio(void)
{
  RCC->AHB1ENR |= RCC_AHB1ENR_GPIOAEN | RCC_AHB1ENR_GPIOBEN | RCC_AHB1ENR_GPIOCEN;
  /* A8, A9, B4, B5, B10, C7 */
  GPIOA->MODER &= ~(GPIO_MODER_MODE8_Msk | GPIO_MODER_MODE9_Msk);
  GPIOA->MODER |= (GPIO_MODER_MODE8_0 | GPIO_MODER_MODE9_0);
  GPIOB->MODER &= ~(GPIO_MODER_MODE10_Msk | GPIO_MODER_MODE5_Msk | GPIO_MODER_MODE4_Msk);
  GPIOB->MODER |= (GPIO_MODER_MODE10_0 | GPIO_MODER_MODE5_0 | GPIO_MODER_MODE4_0);
  GPIOC->MODER &= ~(GPIO_MODER_MODE7_Msk);
  GPIOC->MODER |= (GPIO_MODER_MODE7_0);
}

void lcd_init(void)
{
  lcd_init_gpio();
  gpio_pinset(lcdRS, 0);
  lcd_sendData4(0x3);
  lcd_delay();	// 5ms
  lcd_delay();
  lcd_delay();
  lcd_delay();
  lcd_delay();
  lcd_sendData4(0x3);
  lcd_delay();
  lcd_sendData4(0x3);

  /* Set 4bit interface */
  lcd_sendData4(0x2);
  lcd_sendCmd(0x28);		// 0b00101000
  lcd_sendCmd(0x08);		// 0b00001000
  lcd_sendCmd(LCD_CMD_CLSDISP);
  lcd_sendCmd(0x06);		// 0b00000110
  /* Init end */

  /* Set 2 lines and font */
  lcd_sendCmd(0x28);		// 0b00101000
  /* 1DCB -- turn display on, display cursor, blink character */
  lcd_sendCmd(0x0c);		// 0b00001100
  /* 1DS -- auto increment pointer, shift display to the right */
  lcd_sendCmd(0x06);		// 0b00000110
  lcd_sendCmd(LCD_CMD_CRSHOME);
}

