#ifndef LCD1602A_H_HDR
#define LCD1602A_H_HDR

#include <stdint.h>
#include "main.h"

/*
 *          ----
 *          |
 *          |
 *          |
 *          | RW -- GND
 *          |
 *          |
 *          |
 *          |
 *          | E  -- PC7
 *          | RS -- PA9
 *          ----
 *
 *          ----
 *          | D7 -- PA8
 *          | D6 -- PB10
 *          | D5 -- PB4
 *          | D4 -- PB5
 * */

 typedef enum enmLCDPins_e
 {
   lcdD4,lcdD5,lcdD6,lcdD7,
   lcdRS, lcdE
 } enmLCDPins_t;

#define LCD_CMD_CLSDISP  	(0x01)
#define LCD_CMD_CRSHOME  	(0x02)
#define LCD_CMD_SETDADDR 	(0x80)
#define LCD_CMD_SECOND_LINE (0xC0)

typedef struct adsPin_s
 {
   enmLCDPins_t id;
   GPIO_TypeDef *pgpio;
   uint32_t pin;
 } adsPin_t;

void gpio_pinset(enmLCDPins_t pin, uint32_t value);

void lcd_delay(void);

void lcd_init(void);

void lcd_sendData4(uint8_t ucData);

void lcd_sendCmd(uint8_t ucCmd);

void lcd_sendData(uint8_t ucData);

void lcd_sendText(char *text);

#endif /* LCD1602A_H_HDR */
