/*----------------------------------------------------------------------------
 * Name:    Blinky.c
 *----------------------------------------------------------------------------*/

#include <stdio.h>
#include "EventRecorder.h"
#include "LED_NUCLEO_F401.c"
#include "Buttons_NUCLEO_F401.c"
#include "stm32f4xx.h"                  // Device header
#include <core_cm4.h>

#define setbit(reg, bit)      ((reg) |= (1U << (bit)))
#define clearbit(reg, bit)    ((reg) &= (~(1U << (bit))))

const uint32_t doba_zpozdeni  =  0x42800;
unsigned int output, counter;
unsigned char pole[9]={"Test="};

	
void Delay (uint32_t pocet_ms) 
{    uint32_t pocet, i;
     for (i = 0;i < pocet_ms; i++) 
     {    for (pocet = 0; pocet < doba_zpozdeni; pocet++) i=i;}
}


/*----------------------------------------------------------------------------
 * SystemCoreClockConfigure: configure SystemCoreClock using HSI
                             (HSE is not populated on Nucleo board)
 *----------------------------------------------------------------------------*/
void SystemCoreClockSetHSI(void) {

  RCC->CR |= ((uint32_t)RCC_CR_HSION);                     // Enable HSI
  while ((RCC->CR & RCC_CR_HSIRDY) == 0);                  // Wait for HSI Ready

  RCC->CFGR = RCC_CFGR_SW_HSI;                             // HSI is system clock
  while ((RCC->CFGR & RCC_CFGR_SWS) != RCC_CFGR_SWS_HSI);  // Wait for HSI used as system clock

  FLASH->ACR  = FLASH_ACR_PRFTEN;                          // Enable Prefetch Buffer
  FLASH->ACR |= FLASH_ACR_ICEN;                            // Instruction cache enable
  FLASH->ACR |= FLASH_ACR_DCEN;                            // Data cache enable
  FLASH->ACR |= FLASH_ACR_LATENCY_5WS;                     // Flash 5 wait state

  RCC->CFGR |= RCC_CFGR_HPRE_DIV1;                         // HCLK = SYSCLK
  RCC->CFGR |= RCC_CFGR_PPRE1_DIV4;                        // APB1 = HCLK/4
  RCC->CFGR |= RCC_CFGR_PPRE2_DIV2;                        // APB2 = HCLK/2

  RCC->CR &= ~RCC_CR_PLLON;                                // Disable PLL

  // PLL configuration:  VCO = HSI/M * N,  Sysclk = VCO/P
  RCC->PLLCFGR = ( 16ul                   |                // PLL_M =  16
                 (384ul <<  6)            |                // PLL_N = 384
                 (  3ul << 16)            |                // PLL_P =   8
                 (RCC_PLLCFGR_PLLSRC_HSI) |                // PLL_SRC = HSI
                 (  8ul << 24)             );              // PLL_Q =   8

  RCC->CR |= RCC_CR_PLLON;                                 // Enable PLL
  while((RCC->CR & RCC_CR_PLLRDY) == 0) __NOP();           // Wait till PLL is ready

  RCC->CFGR &= ~RCC_CFGR_SW;                               // Select PLL as system clock source
  RCC->CFGR |=  RCC_CFGR_SW_PLL;
  while ((RCC->CFGR & RCC_CFGR_SWS) != RCC_CFGR_SWS_PLL);  // Wait till PLL is system clock src
}

    
/*----------------------------------------------------------------------------
  MAIN function
 *----------------------------------------------------------------------------*/
int main (void) 
{    char string[10] ="MyTest";   // some test string
     int32_t num  = 5;
     int32_t btns = 0;
     EventRecorderInitialize (EventRecordAll, 1);
     SystemCoreClockSetHSI();
     SystemCoreClockUpdate();                     // Get Core Clock Frequency
     counter=0;
     LED_Initialize();
     Buttons_Initialize();

     while(1)                                     // Nekonecna smycka
     {    btns = Buttons_GetState();              // Cteni tlacitka                              
          LED_On (num); 
          output=1;
          if (btns==1) Delay(20); else Delay(5);  // Zpozdeni 
          counter++;
          printf("cout=%d\n", counter); 
          LED_Off(num); 
    	     if (counter>5) 
          {    EventRecorderStart(); 
               EventRecord2(0x01, counter,3);
          }
          output=0; 
          if (btns==1) Delay(20); else Delay(5);  // Zpozdeni               
     }

}

