/*-----------------------------------------------------------------------------
 * Name:    LED_NUCLEO_F401.c
 * Purpose: LED interface for NUCLEO-L152RE evaluation board
 * Rev.:    1.00
 *----------------------------------------------------------------------------*/

#include "stm32f4xx.h"                         // Device header

#define VYVODY_BRANY  16
#define LED  5


int32_t LED_Initialize (void)                  // void mozno nahradit promennou
{    RCC->AHB1ENR |=  (1ul << 0);              // Povoleni hodinovho signlu pro GPIOA
     // Nastaveni vvodu PA.5 (Zelena LED)  na vstup push-pull, bez upnut k napjen nebo zemi
     GPIOA->MODER   &= ~((3ul << 2*LED));      // Stav po nulovani (ruseni predchoziho stavu)
     GPIOA->MODER   |=  ((1ul << 2*LED));      // Vystup
     GPIOA->OTYPER  &= ~((1ul <<   LED));      // Push-Pull
     GPIOA->OSPEEDR &= ~((3ul << 2*LED));      // Ruseni predchoziho stavu 
     GPIOA->OSPEEDR |=  ((1ul << 2*LED));      // Medium speed
     GPIOA->PUPDR   &= ~((3ul << 2*LED));
     return (0);
}

int32_t LED_On (uint32_t num) 
{    if (num < 16) 
     {    GPIOA->BSRR |= (1ul << LED); }
//  nebo  GPIOA->BSRRL |= (1ul << LED);
     return (0);
}

int32_t LED_Off (uint32_t num) 
{    if (num < 16) 
     {    GPIOA->BSRR |= (1ul << LED)<<16; }
//  nebo  GPIOA->BSRRH |= (1ul << LED);
     return (0);
}
