
import torch.nn as nn


class AdvancedConvNet(nn.Module):
    def __init__(self):
        super(AdvancedConvNet, self).__init__()
        self.conv1 = nn.Conv2d(1, 2, kernel_size=5, padding=0)
        self.conv2 = nn.Conv2d(2, 3, kernel_size=5, padding=0)
        self.fc = nn.Linear(20*20*3, 10)
        self.relu = nn.ReLU()
        self.dropout = nn.Dropout(0.2)
        self.flatten = nn.Flatten(start_dim=1)
    
    def forward(self, x):
        x = self.relu(self.conv1(x))
        x = self.dropout(x)
        x = self.relu(self.conv2(x))
        x = self.flatten(x)
        x = self.fc(x)
        return x
