# -----------------------------------------------------------------------------
# Copyright (c) 2025
# Author: Vojtěch Drahý
#
# Permission is hereby granted to use, modify, and distribute this code
# for personal, academic, and research purposes under a proper citation.
# -----------------------------------------------------------------------------

import random


def generate_random_mealy(n_states=5, n_inputs=4, n_outputs=3, seed=7):
    """
    Generates a random deterministic complete Mealy machine without multiedges (due to visualisation):
      - For every state, each input leads to a unique next_state.
    """
    rng = random.Random(seed)

    states = [f"q{i}" for i in range(n_states)]
    alphabet = [f"e{str(i+1).zfill(2)}" for i in range(n_inputs)]
    outputs = [f"o{i+1}" for i in range(n_outputs)]

    mealy = {s: {} for s in states}

    for s in states:
        # permutation of all possible final states
        next_states = states.copy()
        rng.shuffle(next_states)

        for i, a in enumerate(alphabet):
            s_next = next_states[i % len(states)]   # unique final state
            out = rng.choice(outputs)
            mealy[s][a] = (s_next, out)

    initial_state = states[0]
    return mealy, states, alphabet, outputs, initial_state
