#include <stdio.h>
#include <stdint.h>

union IPv4Address {
   uint32_t addr;     // adresa jako celé číslo (32 bitů)
   uint8_t  bytes[4]; // adresa po jednotlivých bytech
};

int main(void) 
{
   union IPv4Address ip;

   // nastavení adresy "192.168.0.1"
   ip.bytes[0] = 192;
   ip.bytes[1] = 168;
   ip.bytes[2] = 0;
   ip.bytes[3] = 1;

   printf("IPv4 address: %u.%u.%u.%u\n",
         ip.bytes[0], ip.bytes[1], ip.bytes[2], ip.bytes[3]);
   printf("IPv4 as a number: %u\n", ip.addr);
   return 0;
}
