#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MSG_LEN 32

typedef enum {
   MSG_TEXT,
   MSG_SENSOR,
   MSG_COMMAND
} MsgType;

typedef struct {
   MsgType type;
   union {
      char text[MSG_LEN];
      struct {
         int temperature;
         int humidity;
      } sensor;
      int commandId;
   } data;
} Message;

int main(void)
{
   Message m1 = { .type = MSG_TEXT };
   // Text je kratší než MSG_LEN
   strcpy(m1.data.text, "Hello PRP!"); 

   Message m2 = { .type = MSG_SENSOR };
   m2.data.sensor.temperature = 23;
   m2.data.sensor.humidity = 45;

   Message m3 = { .type = MSG_COMMAND };
   m3.data.commandId = 42;

   if (m1.type == MSG_TEXT) {
      printf("Text: %s\n", m1.data.text);
   }
   if (m2.type == MSG_SENSOR) {
      printf("Sensor: %d°C, %d%%\n",
            m2.data.sensor.temperature,
            m2.data.sensor.humidity);
   }
   if (m3.type == MSG_COMMAND) {
      printf("Command ID: %d\n", m3.data.commandId);
   }
   return EXIT_SUCCESS;
}
