#include <stdio.h>
#include <stdlib.h>

#define MAX 10
#define MIN 1
#define ERR_INPUT 100
#define ERR_RANGE 101

int print_line(int count);
void print_triangle(int n);
int check_input(int *pNum, int min, int max);

void print_error(int e, int v);

int main(void)
{
    int ret = 0;

    int num;
    ret = check_input(&num, MIN, MAX);
    if (ret == EXIT_SUCCESS) {
        print_triangle(num);
    }
    print_error(ret, num);
    return ret;
}

int check_input(int *pNum, int min, int max)
{
    int num;

    if (scanf("%d", &num) != 1) {
        return ERR_INPUT;
    }
    if (num > max || num < min) {
        return ERR_RANGE;
    }

    *pNum = num;

    return EXIT_SUCCESS;
}

int print_line(int count)
{
    for (int i = 0; i < count; ++i) {
        printf("*");
    }
    printf("\n");

    return 0;
}

void print_triangle(int n)
{
    for (int i = 0; i < n; ++i) {
        print_line(n - i+1);
    }
}

void print_error(int e, int v)
{
    switch (e) {
    case ERR_INPUT:
        fprintf(stderr,
                "ERROR: Cannot read integer value from the standard input\n");
        break;
    case ERR_RANGE:
        fprintf(stderr,
                "ERROR: Given value %d is not within the range [1, 10]\n", v);
        break;
    }
}
