function [E,dE] = energy(x,r)
E=0;
dE=zeros(size(x));
for i=1:length(r), for j=1:i-1
  [Eij,dEij] = energyij(x(:,i)-x(:,j),r(i)+r(j));
  dE(:,i) = dE(:,i) + dEij;
  dE(:,j) = dE(:,j) - dEij;
  E = E + Eij;
end, end
return

function [E,dE] = energyij(x,r)
k = 3;
b = 1;
d = sqrt(x'*x);
t = d-r;
if t<=0
  E = inf;
  dE = inf;
  return;
end
E = 1/(b*t)^k - 1/t;
dE = (-b*k/(b*t)^(k+1) + 1/t^2) * (x/d);
return