/**
 * @file /include/ecl/geometry.hpp
 *
 * @brief Mathematical tools for geometry.
 *
 * @date May 2009
 **/

/*****************************************************************************
** Ifdefs
*****************************************************************************/

#ifndef ECL_GEOMETRY_HPP_
#define ECL_GEOMETRY_HPP_

/*****************************************************************************
** Eigen's Geometry Module
*****************************************************************************/

#include <ecl/linear_algebra.hpp>

/*****************************************************************************
** Includes
*****************************************************************************/

#include "geometry/macros.hpp"
#include "geometry/angle.hpp"
#include "geometry/cartesian_point.hpp"
#include "geometry/cubic_spline.hpp"
#include "geometry/function_math.hpp"
#include "geometry/homogeneous_point.hpp"
#include "geometry/pascals_triangle.hpp"
#include "geometry/polynomial.hpp"
#include "geometry/smooth_linear_spline.hpp"
#include "geometry/spline_function.hpp"
#include "geometry/tension_function.hpp"
#include "geometry/tension_spline.hpp"
#include "geometry/pose.hpp"
#include "geometry/odometry.hpp"

#endif /*ECL_GEOMETRY_HPP_*/
