
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.StringTokenizer;

public class Probl11b {

    public static void main(String[] args) throws IOException {
        System.setOut(new PrintStream(Files.newOutputStream(Paths.get("probl11Bsol.txt"))));
        BufferedReader in = Files.newBufferedReader(Paths.get("graph.txt"));

        String line = in.readLine();
        int space = line.indexOf(' ');
        final int n = Integer.parseInt(line.substring(0, space));
        final int m = Integer.parseInt(line.substring(space + 1));

        final IntList[] adj = new IntList[n];
        for (int i = 0; i < adj.length; i++) {
            adj[i] = new IntList();
        }

        for (int i = 0; i < m; i++) {
            line = in.readLine();
            StringTokenizer st = new StringTokenizer(line);
            final int u = Integer.parseInt(st.nextToken());
            final int v = Integer.parseInt(st.nextToken());
            adj[u].add(v);
        }

        System.out.println("SP lenght : " + spLen(adj, 0, 7));
    }

    
    static int spLen(IntList[] adj, int s, int t) {
        for(int i = 0; i < adj.length; i++)
            if(dfs(adj, s, new boolean[adj.length], t, i))
                return i;
        return -1; // nothing found
    }
    
    static boolean dfs(IntList[] adj, int s, boolean[] visited, int t, int maxDepth) {
        if(s == t) return true;
        if(maxDepth == 0)
            return false;

        visited[s] = true;

        for (int w : adj[s]) {
            if (!visited[w]) {
                if(dfs(adj, w, visited, t, maxDepth - 1))
                    return true;
            }
        }
        return false;
    }
}
