
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.StringTokenizer;

public class Probl11a {

    public static void main(String[] args) throws IOException {
        System.setOut(new PrintStream(Files.newOutputStream(Paths.get("probl11Asol.txt"))));
        BufferedReader in = Files.newBufferedReader(Paths.get("graph.txt"));

        String line = in.readLine();
        int space = line.indexOf(' ');
        final int n = Integer.parseInt(line.substring(0, space));
        final int m = Integer.parseInt(line.substring(space + 1));

        final IntList[] adj = new IntList[n];
        for (int i = 0; i < adj.length; i++) {
            adj[i] = new IntList();
        }

        for (int i = 0; i < m; i++) {
            line = in.readLine();
            StringTokenizer st = new StringTokenizer(line);
            final int u = Integer.parseInt(st.nextToken());
            final int v = Integer.parseInt(st.nextToken());
            adj[u].add(v);
        }

        System.out.println("No. of visitable : " + visitable(adj, 0));
    }

    
    static int visitable(IntList[] adj, int s) {
        final boolean[] visited = new boolean[adj.length];
        return dfs(adj, s, visited);
    }
    
    static int dfs(IntList[] adj, int s, boolean[] visited) {
        int count = 1; // 1 for s
        visited[s] = true;

        for (int w : adj[s]) {
            if (!visited[w]) {
                count += dfs(adj, w, visited);
            }
        }
        return count;
    }
}
