#include "sachovnice.h"
#include <QWidget>
#include <QLabel>
#include <QPushButton>
#include <QGridLayout>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QStatusBar>
#include <QList>
#include <QFrame>
#include <QTimer>

#include <QDebug>

#include <QStyle>

#define POLE_BILE       "background-color: white; color: black;"
#define POLE_CERNE      "background-color: black; color: white;"
#define POLE_BILE_RAM   "background-color: white; color: black; border: 3px solid #ff0000;"
#define POLE_CERNE_RAM  "background-color: black; color: white; border: 3px solid #ff0000;"

Sachovnice::Sachovnice(QWidget *parent)
    : QMainWindow(parent)
{
    QWidget *w = new QWidget;
    setCentralWidget(w);        // musi se nastavit central widget drive nez se zacnou hledat objekty

    QGridLayout *sachovnice = new QGridLayout;

    sachovnice->cellRect(8, 8);

    for(int i=0; i<8; i++){
        for (int j=0; j<8; j++){
            QPushButton *btn = new QPushButton;
            QString btnText = QString("%1%2").arg(QChar('A' + j)).arg(8-i);
            btn->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
            btn->setText(btnText);
            btn->setObjectName(btnText);

            if((i+j)%2 == 0){
                btn->setStyleSheet(POLE_BILE);
            }
            else{
                btn->setStyleSheet(POLE_CERNE);
            }

            sachovnice->addWidget(btn, i, j);
        }
    }

    // oddeleni sachovnice od tlacitek
    QVBoxLayout *vLayout = new QVBoxLayout;

    QFrame *hLine = new QFrame();
    hLine->setFrameShape(QFrame::HLine);

    QHBoxLayout *row = new QHBoxLayout;


    // tlacitka casovace
    QPushButton *btnStart = new QPushButton("Timer Start");
    row->addWidget(btnStart);

    QPushButton *btnStop = new QPushButton("Timer Stop");
    row->addWidget(btnStop);

    vLayout->addLayout(sachovnice);
    vLayout->addWidget(hLine);
    vLayout->addLayout(row);

    // Status bar
    QStatusBar *status = new QStatusBar;
    vLayout->addWidget(status);
    w->setLayout(vLayout);

    QLabel *lblStatus = new QLabel("Left");
    status->addPermanentWidget(lblStatus, 25);

    // pro widget
    w->setMinimumSize(300, 300);
    w->setMaximumHeight(600);
    w->setMaximumWidth(600);
    w->resize(400, 400);

    // pro mainWindow
    // ??

}


// Slots:
void Sachovnice::buttonClicked(void){
    QPushButton *btn = nullptr;

    if(!btn)
        return;

    QStringList btnName = btn->objectName().split("", Qt::SkipEmptyParts);
    QByteArray xArray = btnName.at(0).toLatin1();
    int x = xArray.at(0) - 'A';
    int y = btnName.at(1).toInt();

    QString objName;

    QLabel *lblStatus = centralWidget()->findChild<QLabel*>("lblStatusLeft");
    lblStatus->setText(QString("Stisknuto %1").arg(btn->objectName()));

    for(int a = 0; a<8; a++){
        for(int b = 0; b<8; b++){
            objName = QString("%1%2").arg(QChar('A'+a)).arg(b+1);
            QPushButton *btnPole = centralWidget()->findChild<QPushButton*>(objName);
            if((a+b)%2 == 1){
                btnPole->setStyleSheet(POLE_BILE);
            }
            else{
                btnPole->setStyleSheet(POLE_CERNE);
            }
        }
    }

    // vyznaceni diagonal
    for(int i=0; i<16; i++){
        objName = QString("%1%2").arg(QChar('A'+x + i-8)).arg(y - i+8);
        QPushButton *btnPole = centralWidget()->findChild<QPushButton*>(objName);
        if(btnPole){
            if((x+y)%2 == 0){
                btnPole->setStyleSheet(POLE_BILE_RAM);
            }
            else{
                btnPole->setStyleSheet(POLE_CERNE_RAM);
            }
        }

        objName = QString("%1%2").arg(QChar('A'+x + i-8)).arg(y + i-8);
        btnPole = centralWidget()->findChild<QPushButton*>(objName);
        if(btnPole){
            if((x+y)%2 == 0){
                btnPole->setStyleSheet(POLE_BILE_RAM);
            }
            else{
                btnPole->setStyleSheet(POLE_CERNE_RAM);
            }
        }
    }
}

// Destructor:
Sachovnice::~Sachovnice() {

}
