#include <iostream>

template<class T>
void swap (T &a, T &b) {
    T c(a); // T c; c = a
    a = b;
    b = c;
}

// class <-> typename
// formalni promenna muze mit libovolny identifikator, zvykem je T
// formalnich typu muze byt i vice
template<typename A>
A max (A a, A b)
{
    return a > b ? a : b;
}

template<class T1, class T2>
T1 min (T1 a, T2 b)
{
    return a <= b ? a : b;
}

int max (int *a, int *b)
{
    return (*a > *b) ? *a : *b;
}

int main()
{
    int a = 10, b = 20;
    std::cout << "a: " << a << ", b: " << b << "\n";
    swap(a, b);
    std::cout << "a: " << a << ", b: " << b << "\n";

    std::cout << "10 / 20: " << ::max(10, 20) << "\n";
    std::cout << "a  /  b: " << ::max('b', 'a') << "\n";
    std::cout << "60 /  a: " << ::max<int>(60, 'a') << "\n";
    std::cout << "60 /  a: " << ::max<char>(60, 'a') << "\n";

    int c = 100; 
    int d = 200;

    // je volana nikoliv instance sablony, ale pretizena funkce max
    // ktera ma explicitni datovy typ argumentu: int*
    std::cout << ::max(&c, &d) << "\n";

    return 0;
}