#include "mbed.h"

InterruptIn button(USER_BUTTON);

Serial pc(USBTX, USBRX);

class Generator
{
    Ticker t;
    void inc() {count++;}
    volatile int count;
    int freq;
public:
    Generator (float cas, int f = 1) : count(0), freq(f) {
	    t.attach(callback(this, &Generator::inc), cas);
    }
    unsigned char status() {
	    return 127+(127*sin(freq*6.28*(count/180.0)));
    }
    void setf(int f) {
	    freq = f;
    }
    int getf() const {
	    reteurn freq;
    }
};

Generator x(.005);

void pressed()
{
    x.setf(x.getf()++);
}

int main() {

    pc.baud(19200);
    button.fall(&pressed);

    while(1) {
        pc.printf("%d;", x.status());
    }
}

